<?xml version="1.0" encoding="UTF-8"?>
<xs:stylesheet version="1.0" xmlns:xs="http://www.w3.org/1999/XSL/Transform" xmlns:xs_a="TransformAliasFor_xs" xmlns:tsl="http://www.topcall.com/2004/tsl" xmlns:tsl_a="TransformAliasFor_tsl">
  
	<xs:output method="xml" version="1.0" encoding="UTF-8" indent="yes"/>
	<xs:namespace-alias stylesheet-prefix="xs_a" result-prefix="xs"/>
	<xs:namespace-alias stylesheet-prefix="tsl_a" result-prefix="tsl"/>
	<xs:variable name="paglen" select="10"/>
	<xs:template match="SolutionConfig">
		<CellConfig xmlns:xi="http://www.w3.org/2001/XInclude" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="../xcd/CellConfig.xsd">
			<Common>
				<SolutionInfo>
  				<Version>n/a</Version> <!-- Version not specified now -->
  				<Name>TNA_Fax</Name>
				</SolutionInfo>
				<SolutionShortName>TNA_Fax</SolutionShortName>
				<Supervisor>
					<WinSrv/>
				</Supervisor>
				<xs:call-template name="MasterTrace"/>
				<DirectInterface>
					<xs:copy-of select="FaxServer/Path"/>
					<xs:copy-of select="FaxServer/ServiceName"/>
					<xs:copy-of select="FaxServer/CodePage"/>
				</DirectInterface>
				<Checks>
					<xs:choose>
						<xs:when test="FaxServer/Type='KCS'">
							<File>
								<PathName>base:bin\tclib32.dll</PathName>
								<Flags>1</Flags>
							</File>
							<File>
								<PathName>base:bin\tcti32.dll</PathName>
								<Flags>1</Flags>
							</File>
							<File>
								<PathName>base:bin\tcsi32.dll</PathName>
								<Flags>1</Flags>
							</File>
							<File>
								<PathName>base:bin\TNC_Tcsi.dll</PathName>
								<Flags>1</Flags>
							</File>
							<File>
								<PathName>base:bin\Tnc_Imageio.dll</PathName>
								<Flags>1</Flags>
							</File>
							<File>
								<PathName>base:bin\TNC_tsl.dll</PathName>
								<Flags>1</Flags>
							</File>
						</xs:when>
						<xs:when test="FaxServer/Type='RightFax'">
							<File>
								<PathName>base:bin\TNC_RFax.dll</PathName>
								<Flags>1</Flags>
							</File>
						</xs:when>
						<xs:when test="FaxServer/Type='Biscom'">
							<File>
								<PathName>base:bin\TnSlave.exe</PathName>
								<Flags>0</Flags>
							</File>
							<File>
								<PathName>base:bin\TNC_BISCOM.dll</PathName>
								<Flags>1</Flags>
							</File>
						</xs:when>
						<xs:when test="FaxServer/Type='FaxWS'">
							<File>
								<PathName>base:bin\TNC_Tsl.dll</PathName>
								<Flags>1</Flags>
							</File>
							<File>
								<PathName>base:bin\TNC_Http.dll</PathName>
								<Flags>1</Flags>
							</File>
						</xs:when>
						<xs:when test="FaxServer/Type='Test'">
							<File>
								<PathName>base:bin\TNC_Tsl.dll</PathName>
								<Flags>1</Flags>
							</File>
						</xs:when>
					</xs:choose>
				</Checks>
			</Common>
			<ProcessList>
				<xs:choose>
				
					<xs:when test="FaxServer/Type='KCS'">
						<Process>	
							<Common>
								<ExePathName>.</ExePathName>
							</Common>						
							<ComponentList>
								<Component>
									<Common>
										<Name>TCSI Connector to TCOSS</Name>
										<PlugInDll>base:bin\TNC_Tcsi.dll</PlugInDll>
										<Target>tcoss</Target>										
										<xs:call-template name="ComponentTrace"/>
									</Common>
									<Code>
										<TncTcsi>
											<TclibModuleName>TWS</TclibModuleName>
											<TclibOpenFlags>1</TclibOpenFlags>
											<MaxSessions>500</MaxSessions>
											<Server>
												<Path>
													<xs:value-of select="FaxServer/Path"/>										
												</Path>
												<Codepage>
													<xs:value-of select="FaxServer/CodePage"/>
												</Codepage>
											</Server>
										</TncTcsi>
									</Code>
								</Component>
							</ComponentList>
						</Process>
						<Process>
							<Common>
								<ExePathName>.</ExePathName>
							</Common>							
							<ComponentList>
								<Component>
									<Common>
										<Name>ImageIO Converter</Name>
										<PlugInDll>base:bin\Tnc_Imageio.dll</PlugInDll>										
										<Target>imageio</Target>
										<xs:call-template name="ComponentTrace"/>
									</Common>
									<Code>
										<TncImageio>
											<TclibModuleName>TWS</TclibModuleName>
											<TclibOpenFlags>1</TclibOpenFlags>
										</TncImageio>
									</Code>
								</Component>
							</ComponentList>
						</Process>
						<Process>
							<Common>
								<ExePathName>.</ExePathName>
							</Common>
							<ComponentList>
								<Component>
									<Common>
										<Name>Workflow Component</Name>
										<PlugInDll>base:bin\TNC_Tsl.dll</PlugInDll>
										<Target>fax</Target>
										<xs:call-template name="ComponentTrace"/>
									</Common>
									<Code>
										<TncTsl>
											<xs_a:stylesheet version="1.0" xmlns:tsl="http://www.topcall.com/2004/tsl" xmlns:s="http://schemas.xmlsoap.org/soap/envelope/" xmlns:tc="http://www.topcall.com/XMLSchema/2004/tcsi" xmlns="http://www.topcall.com/2006/Fax">
												<xs_a:output method="xml" version="1.0" encoding="UTF-8"/>										
												<xs_a:template match="GetServerProperties">
													<xs_a:variable name="complexversion">
														<Version>1.1:<xs:value-of select="document('SolutionInfo.xml')/SolutionInfo/Version"/>::</Version>
													</xs_a:variable>
													<xs_a:variable name="servres">
														<!-- test tcoss connection by reading tcoss program version -->
														<!-- <res> removed since TnLib 3.02.00 -->
														<tsl_a:invoke target="tcoss">
															<CallServer xmlns="">
																<xs_a:copy-of select="ServerInfo"/>
																<tc:set_get_program_version/>
															</CallServer>
														</tsl_a:invoke>
														<!-- </res> -->
													</xs_a:variable>
													<xs_a:choose>
														<xs_a:when test="$servres/Fault">
															<!-- tcoss connection problem, pass on returned Fault -->
															<xs_a:copy-of select="$servres/Fault"/>
														</xs_a:when>
														<xs_a:otherwise>
															<!-- tcoss connection ok -->
															<ServerProperties>
																<Type>TCOSS</Type>
																<Version>
																	<xs_a:value-of select="$complexversion"/>
																</Version>
																<SupportedOptions>
																	<Option>UserList</Option>
																	<Option>SharedServer</Option>
																</SupportedOptions>
															</ServerProperties>
														</xs_a:otherwise>
													</xs_a:choose>
												</xs_a:template>																			
												<xs_a:template match="SendFax">
													<!-- get TCOSS originator structure from the user id configured in the TCOSS connector or passed as credentials  -->
													<xs_a:variable name="originator">
														<!-- <originator> removed since TnLib 3.02.00 -->
														<xs_a:call-template name="LoadOriginator"/>
														<!-- </originator> -->
													</xs_a:variable>
													<!-- convert input TIFF data to TCI blocks -->
													<xs_a:variable name="tciresp">
														<!-- <tciresp> removed since TnLib 3.02.00 -->
														<tsl_a:invoke tsl_a:target="imageio">
															<c:image2tci_req xmlns:c="http://www.topcall.com/XMLSchema/2004/imageio">
																<c:imageformat>TIFF</c:imageformat>
																<c:message>
																	<tc:blk_binary>
																		<xs_a:value-of select="Body/TiffData"/>
																	</tc:blk_binary>
																</c:message>
															</c:image2tci_req>
														</tsl_a:invoke>
														<!-- </tciresp> -->
													</xs_a:variable>
													<!-- check whether the previous 2 steps went ok, then post the message to TCOSS -->
													<xs_a:choose>
														<xs_a:when test="$originator/Fault">
															<xs_a:copy-of select="$originator/Fault"/>
														</xs_a:when>
														<xs_a:when test="$tciresp/Fault">
															<xs_a:copy-of select="$tciresp/Fault"/>
														</xs_a:when>
														<xs_a:otherwise>
															<tsl_a:invoke tsl_a:target="tcoss">
																<CallServer xmlns="">
																	<xs_a:copy-of select="ServerInfo"/>
																	<tc:set_write_at>
																		<tc:set_entry.set_entry_ms>
																			<tc:un_content.l_env_cont>
																				<tc:set_header>
																					<tc:int_termination>
																						<xs_a:choose>
																							<xs_a:when test="Header/KeepOnFailure='1'">209</xs_a:when>
																							<xs_a:when test="Header/KeepOnFailure='true'">209</xs_a:when>
																							<xs_a:otherwise>243</xs_a:otherwise>
																						</xs_a:choose>
																					</tc:int_termination>
																					<tc:ts_ref>
																						<xs_a:value-of select="Header/Subject"/>
																					</tc:ts_ref>
																					<tc:set_entry_rs_originator.set_entry_rs>
																						<xs_a:copy-of select="$originator/set_entry_rs/*"/>
																					</tc:set_entry_rs_originator.set_entry_rs>
																					<tc:l_recipients>
																						<tc:set_entry_rs>
																							<tc:int_active>1</tc:int_active>
																							<tc:int_del_type>1</tc:int_del_type>
																							<tc:l_full_addr>
																								<tc:set_full_address>
																									<tc:int_active>1</tc:int_active>
																									<tc:ts_service>
																										<xs_a:choose>
																											<xs_a:when test="Header/ServiceName">
																												<xs_a:value-of select="Header/ServiceName"/>
																											</xs_a:when>
																											<xs_a:otherwise>
																												<xs:value-of select="FaxServer/ServiceName"/>
																											</xs_a:otherwise>
																										</xs_a:choose>
																									</tc:ts_service>
																									<tc:un_public_address.set_fax_address>
																										<tc:ts_fax_number>
																											<xs_a:value-of select="Header/NumberToDial"/>
																										</tc:ts_fax_number>
																										<xs_a:choose>
																											<xs_a:when test="Header/ExpectedCSI">
																												<tc:ts_fax_answerb>
																													<xs_a:value-of select="Header/ExpectedCSI"/>
																												</tc:ts_fax_answerb>
																											</xs_a:when>
																										</xs_a:choose>
																									</tc:un_public_address.set_fax_address>
																								</tc:set_full_address>
																							</tc:l_full_addr>
																						</tc:set_entry_rs>
																					</tc:l_recipients>
																				</tc:set_header>
																				<tc:obj_body_part/>
																				<xs_a:choose>
																					<xs_a:when test="Header/SourceTSI">
																						<tc:set_blk_txt>
																							<tc:un_content.blk_txt>++TSI <xs_a:value-of select="Header/SourceTSI"/>,<xs_a:value-of select="Header/NameOfSender"/>
																							</tc:un_content.blk_txt>
																						</tc:set_blk_txt>
																					</xs_a:when>
																				</xs_a:choose>
																				<xs_a:copy-of select="$tciresp/image2tci_resp/message/l_env_cont/*"/>
																			</tc:un_content.l_env_cont>
																		</tc:set_entry.set_entry_ms>
																	</tc:set_write_at>
																</CallServer>
															</tsl_a:invoke>
														</xs_a:otherwise>
													</xs_a:choose>
												</xs_a:template>										
												<xs_a:template name="LoadOriginator">
													<xs_a:variable name="user">
														<tsl_a:invoke tsl_a:target="tcoss">
															<GetUserId xmlns=""/>
														</tsl_a:invoke>
													</xs_a:variable>
													<tsl_a:invoke tsl_a:target="tcoss">
														<CallServer xmlns="">
															<xs_a:copy-of select="ServerInfo"/>
															<tc:set_open_read>
																<tc:set_selector_entry.set_entry_rs>
																	<tc:ts_section>+TECH</tc:ts_section>
																	<tc:ts_recp_id>
																		<xs_a:value-of select="$user"/>
																	</tc:ts_recp_id>
																</tc:set_selector_entry.set_entry_rs>
															</tc:set_open_read>
														</CallServer>
													</tsl_a:invoke>
												</xs_a:template>										
											</xs_a:stylesheet>
										</TncTsl>
									</Code>
								</Component>
							</ComponentList>
						</Process>
					</xs:when>

					<xs:when test="FaxServer/Type='RightFax'">
						<!-- generate a response without sending a fax -->
						<Process>
							<Common>
								<ExePathName>.</ExePathName>
							</Common>
							<ComponentList>
								<Component>
									<Common>
										<Name>Workflow Component</Name>
										<PlugInDll>base:bin\TNC_RFax.dll</PlugInDll>
										<Target>fax</Target>
										<xs:call-template name="ComponentTrace"/>
									</Common>
									<Code>
										<TncRFax>
											<Server>
												<Name>
													<xs:value-of select="FaxServer/Path"/>
												</Name>
											</Server>
											<Locking>
												<Timeout>1800</Timeout>
												<WaitTimeout>1800</WaitTimeout>
												<LockDir>./Config/</LockDir>
											</Locking>
										</TncRFax>
									</Code>
								</Component>
							</ComponentList>
						</Process>
					</xs:when>
					
					<xs:when test="FaxServer/Type='Biscom'">
						<!-- generate a response without sending a fax -->
						<Process>
							<Common>
								<!-- Run TNC_BISCOM in new thread. Workaround for hang at shutdown -->
								<ExePathName>base:bin\TnSlave.exe</ExePathName>
							</Common>
							<ComponentList>
								<Component>
									<Common>
										<Name>Native connector to BISCOM</Name>
										<PlugInDll>base:bin\TNC_BISCOM.dll</PlugInDll>
										<Target>fax</Target>
										<xs:call-template name="ComponentTrace"/>
									</Common>
									<Code>
										<TncBiscom>
											<Server>
												<Name>
													<xs:value-of select="FaxServer/Path"/>
												</Name>
											</Server>
											<Locking>
												<Timeout>1800</Timeout>
												<WaitTimeout>1800</WaitTimeout>
												<LockDir>./Config/</LockDir>
											</Locking>
										</TncBiscom>
									</Code>
								</Component>
							</ComponentList>
						</Process>
					</xs:when>
					
					<xs:when test="FaxServer/Type='Test'">
						<!-- generate a response without sending a fax -->
						<Process>
							<Common>
								<ExePathName>.</ExePathName>
							</Common>
							<ComponentList>
								<Component>
									<Common>
										<Name>Workflow Component</Name>
										<PlugInDll>base:bin\TNC_Tsl.dll</PlugInDll>
										<Target>fax</Target>
										<xs:call-template name="ComponentTrace"/>
									</Common>
									<Code>
										<TncTsl>
											<xs_a:stylesheet version="1.0">
												<xs_a:template match="GetServerProperties">
													<ServerProperties xmlns="http://www.topcall.com/2006/Fax">
														<Type>Test Mode</Type>
														<Version>1.1:1.0::</Version>
														<SupportedOptions/>
													</ServerProperties>
												</xs_a:template>
												<xs_a:template match="SendFax">
													<ok xmlns="http://www.topcall.com/XMLSchema/2004/tn" />
												</xs_a:template>
											</xs_a:stylesheet>
										</TncTsl>
									</Code>
								</Component>
							</ComponentList>
						</Process>
					</xs:when>

					<xs:when test="FaxServer/Type='FaxWS'">
						<!-- call the Fax Web Service -->
						<Process>
							<Common>
								<ExePathName>.</ExePathName>
							</Common>
							<ComponentList>
								<Component>
									<Common>
										<Name>Workflow Component</Name>
										<PlugInDll>base:bin\TNC_Tsl.dll</PlugInDll>
										<Target>fax</Target>
										<xs:call-template name="ComponentTrace"/>
									</Common>
									<Code>
										<TncTsl>
											<xs_a:stylesheet version="1.0">
												<xs_a:template match="*">
													<tsl_a:invoke target="http">
														<CallWebService>
															<Url><xs:value-of select="FaxServer/WebServiceUrl"/></Url>
															<Body>
																<xs_a:copy-of select="."/>
															</Body>
														</CallWebService>
													</tsl_a:invoke>
												</xs_a:template>
											</xs_a:stylesheet>
										</TncTsl>
									</Code>
								</Component>
							</ComponentList>
						</Process>
						<Process>
							<Common>
								<ExePathName>.</ExePathName>
							</Common>
							<ComponentList>
								<Component>
									<Common>
										<Name>Http Connector</Name>
										<PlugInDll>base:bin\TNC_Http.dll</PlugInDll>
										<Target>http</Target>
										<xs:call-template name="ComponentTrace"/>
									</Common>
									<Code>
										<TncHttp>
											<WebService>
												<TcpPort>0</TcpPort>
											</WebService>
										</TncHttp>
									</Code>
								</Component>
							</ComponentList>
						</Process>
					</xs:when>
				</xs:choose>	
			</ProcessList>
		</CellConfig>
	</xs:template>
	<xs:template name="MasterTrace">
		<Trace>
			<File>
				<MaxSize><xs:value-of select="Advanced/TraceFileSize"/></MaxSize>
				<MaxCount><xs:value-of select="Advanced/TraceFiles"/></MaxCount>
				<xs:choose>
					<xs:when test="Advanced/AppendTrace">
						<Append><xs:value-of select="Advanced/AppendTrace"/></Append>
					</xs:when>
				</xs:choose>
				<xs:choose>
					<xs:when test="Advanced/TraceFilePrefix">
						<PathName><xs:value-of select="Advanced/TraceFilePrefix"/></PathName>
					</xs:when>
					<xs:otherwise>
						<PathName>%TMP%\Kofax\TNA_Fax_</PathName>
					</xs:otherwise>
				</xs:choose>
				<Extension>.log</Extension>
			</File>
			<MasterLevel><xs:value-of select="Advanced/TraceLevel"/></MasterLevel>
		</Trace>
	</xs:template>
	
	<xs:template name="ComponentTrace">
		<Trace>
			<MasterLevel><xs:value-of select="Advanced/TraceLevel"/></MasterLevel>
			<MessageDump>
				<ToTn>
					<MaxSize><xs:value-of select="Advanced/MessageTraceSize"/></MaxSize>
				</ToTn>
				<FromTn>
					<MaxSize><xs:value-of select="Advanced/MessageTraceSize"/></MaxSize>
				</FromTn>
			</MessageDump>
		</Trace>
	</xs:template>

</xs:stylesheet>
