'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: IKfxReleaseSetupScript.vb
'
' Purpose: Defines Setup COM interface which is compatible with Kofax Capture.
'
' ****************************************************************************
Imports System.Runtime.InteropServices
Imports Kofax.ReleaseLib

''' <summary>
''' Defines Setup COM interface which is compatible with Kofax Capture.
''' </summary>
''' <remarks></remarks>
<ComVisible(True)> _
<InterfaceType(ComInterfaceType.InterfaceIsIDispatch)> _
Public Interface IKfxReleaseSetupScript
    ''' <summary>
    ''' Sets or gets the KC SetupData object.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Property SetupData() As IReleaseSetupData
    ''' <summary>
    ''' Handles KC OpenScript events.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Function OpenScript() As KfxReturnValue
    ''' <summary>
    ''' Handles KC CloseScript events.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Function CloseScript() As KfxReturnValue
    ''' <summary>
    ''' Handles the KC ActionEvents.
    ''' </summary>
    ''' <param name="ActionID"></param>
    ''' <param name="strData1"></param>
    ''' <param name="strData2"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Function ActionEvent(ByRef ActionID As KfxActionValue, _
        ByRef strData1 As String, _
        ByRef strData2 As String) As KfxReturnValue
    ''' <summary>
    ''' Handles KC RunUI events.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Function RunUI() As KfxReturnValue
End Interface