'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: KfxReleaseScript.vb
'
' Purpose: The implementation of the interface IKfxReleaseScript.
'
' ****************************************************************************
Imports System.Runtime.InteropServices
Imports Kofax.FaxRel.Connector
Imports Kofax.TAPCommon.TAPLib
Imports Kofax.ReleaseLib

''' <summary>
''' The implementation of the interface IKfxReleaseScript.
''' </summary>
''' <remarks></remarks>
<ComVisible(True)> _
<ClassInterface(ClassInterfaceType.None)> _
<Guid("7BE2AEC9-9D89-41f9-B9F9-80999D9E501F")> _
<ProgId("KCFaxRelease.ReleaseScript")> _
Public Class KfxReleaseScript
    Implements IKfxReleaseScript
    Const cm_strScriptName As String = "Kofax Capture Export Connector - Fax"
    Private m_oReleaseDataAdapter As ReleaseDataAdapter
    Private m_oRelease As Release
    ' A creatable COM class must have a Public Sub New() 
    ' with no parameters, otherwise, the class will not be 
    ' registered in the COM registry and cannot be created 
    ' via CreateObject.
    Public Sub New()
        MyBase.New()
    End Sub
    ''' <summary>
    ''' Sets or gets the KC IReleaseData.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property DocumentData() As Kofax.ReleaseLib.IReleaseData Implements IKfxReleaseScript.DocumentData
        Get
            Return m_oReleaseDataAdapter.IReleaseData
        End Get
        Set(ByVal value As Kofax.ReleaseLib.IReleaseData)
            If m_oReleaseDataAdapter Is Nothing Then
                m_oReleaseDataAdapter = New ReleaseDataAdapter(value)
            Else
                m_oReleaseDataAdapter.Dispose()
                m_oReleaseDataAdapter.IReleaseData = value
            End If
        End Set
    End Property
    ''' <summary>
    ''' Handles the KC OpenScript event.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function OpenScript() As Kofax.ReleaseLib.KfxReturnValue Implements IKfxReleaseScript.OpenScript
        Dim eResult As Kofax.ReleaseLib.KfxReturnValue = KfxReturnValue.KFX_REL_SUCCESS
        Try
            m_oRelease = New Release(CType(m_oReleaseDataAdapter, IReleaseDataNet))
            m_oRelease.InitializeFax()
        Catch ex As Exception
            eResult = KfxReturnValue.KFX_REL_ERROR
        End Try
        Return eResult
    End Function
    ''' <summary>
    ''' Handles the KC CloseScript event.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function CloseScript() As Kofax.ReleaseLib.KfxReturnValue Implements IKfxReleaseScript.CloseScript
        Dim eResult As Kofax.ReleaseLib.KfxReturnValue = KfxReturnValue.KFX_REL_SUCCESS
        Try
            If Not m_oRelease Is Nothing Then
                m_oRelease.DeInitializeFax()
            End If
        Catch ex As Exception
        End Try
        Try
            If Not m_oReleaseDataAdapter Is Nothing Then
                m_oReleaseDataAdapter.Dispose()
            End If
        Catch ex As Exception
        End Try
        Return eResult
    End Function
    ''' <summary>
    ''' Handles the KC ReleaseDoc event.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ReleaseDoc() As Kofax.ReleaseLib.KfxReturnValue Implements IKfxReleaseScript.ReleaseDoc
        Try
            ' Initializes logger for release module
            'Logger.InitReleaseData(CType(m_oReleaseDataAdapter, IReleaseDataNet), cm_strScriptName)
            ' Releases document
            Return m_oRelease.ReleaseDoc(CType(m_oReleaseDataAdapter, IReleaseDataNet))
        Finally
            ' Closes the Logger.
            'Logger.Close()
        End Try
    End Function
End Class
