'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: KfxReleaseSetupScript.vb
'
' Purpose: Implementation of IKfxReleaseSetupScript interface.
'
' ****************************************************************************
Imports System.Runtime.InteropServices
Imports Kofax.FaxRel.Connector
Imports Kofax.ReleaseLib
Imports Kofax.TAPCommon.TAPLib

''' <summary>
''' Implementation of IKfxReleaseSetupScript interface.
''' </summary>
''' <remarks></remarks>
<ComVisible(True)> _
<ClassInterface(ClassInterfaceType.None)> _
<Guid("86AC58E3-D2AB-4c3a-95CC-A3AF7A323805")> _
<ProgId("KCFaxRelease.ReleaseSetupScript")> _
Public Class KfxReleaseSetupScript
    Implements IKfxReleaseSetupScript
    Const cm_strScriptName As String = "Kofax Capture Export Connector - Fax"
    Private m_oSetupDataAdapter As ReleaseSetupDataAdapter
    Private m_oActionEventHandler As New ActionEventHandler()
    ' A creatable COM class must have a Public Sub New() 
    ' with no parameters, otherwise, the class will not be 
    ' registered in the COM registry and cannot be created 
    ' via CreateObject.
    Public Sub New()
        MyBase.New()
    End Sub
    ''' <summary>
    ''' Sets or gets the KC SetupData object.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Property SetupData() As Kofax.ReleaseLib.IReleaseSetupData Implements IKfxReleaseSetupScript.SetupData
        Get
            Return m_oSetupDataAdapter.IReleaseSetupData
        End Get
        Set(ByVal value As Kofax.ReleaseLib.IReleaseSetupData)
            If (m_oSetupDataAdapter Is Nothing) Then
                m_oSetupDataAdapter = New ReleaseSetupDataAdapter(value)
            Else
                m_oSetupDataAdapter.Dispose()
                m_oSetupDataAdapter.IReleaseSetupData = value
            End If
        End Set
    End Property

    ''' <summary>
    ''' Handles KC OpenScript events.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function OpenScript() As Kofax.ReleaseLib.KfxReturnValue Implements IKfxReleaseSetupScript.OpenScript
        Return KfxReturnValue.KFX_REL_SUCCESS
    End Function
    ''' <summary>
    ''' Handles KC CloseScript events.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function CloseScript() As Kofax.ReleaseLib.KfxReturnValue Implements IKfxReleaseSetupScript.CloseScript
        If Not m_oSetupDataAdapter Is Nothing Then
            m_oSetupDataAdapter.Dispose()
        End If
        ' Closes the logger. Initializes in the RunUI event.
        'Logger.Close()
        Return KfxReturnValue.KFX_REL_SUCCESS
    End Function
    ''' <summary>
    ''' Handles KC ActionEvent events.
    ''' </summary>
    ''' <param name="ActionID"></param>
    ''' <param name="strData1"></param>
    ''' <param name="strData2"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function ActionEvent(ByRef ActionID As Kofax.ReleaseLib.KfxActionValue, ByRef strData1 As String, ByRef strData2 As String) As Kofax.ReleaseLib.KfxReturnValue Implements IKfxReleaseSetupScript.ActionEvent
        Try
            Return m_oActionEventHandler.ActionEvent(CType(m_oSetupDataAdapter, IReleaseSetupDataNet), ActionID, strData1, strData2)
        Catch e As Exception
            Return KfxReturnValue.KFX_REL_ERROR
        End Try
    End Function
    ''' <summary>
    ''' Handles KC RunUI events.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function RunUI() As Kofax.ReleaseLib.KfxReturnValue Implements IKfxReleaseSetupScript.RunUI
        Try
            Dim oSetup As New Setup()
            Dim eResult As KfxReturnValue = oSetup.ShowForm(CType(m_oSetupDataAdapter, IReleaseSetupDataNet))
            ' Initializes the logger for the script. Close in CloseScript event.
            'Logger.InitReleaseSetupData(m_oSetupDataAdapter, cm_strScriptName)
            Return eResult
        Catch ex As Exception
            Return KfxReturnValue.KFX_REL_ERROR
        End Try
    End Function
End Class
