'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: ConnectorFactory.vb
'
' Purpose: Defines the factory class for creating fax connectors.
'
' ****************************************************************************
''' <summary>
''' Defines the factory class for creating fax connectors.
''' </summary>
''' <remarks></remarks>
Public Class ConnectorFactory
    ''' <summary>
    ''' Creates a list of implementation fax connectors.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetConnectors() As IList(Of IConnector)
        Dim oConnectors As New List(Of IConnector)
        oConnectors.Add(New KofaxCommunicationServerConnector())
        oConnectors.Add(New RightFaxConnector())
        oConnectors.Add(New BiscomFAXCOMConnector())
        Return oConnectors
    End Function
    ''' <summary>
    ''' Creates an instance of the IConnector object based on its internal name.
    ''' </summary>
    ''' <param name="strConnectorName">The internal name of the connector.</param>
    ''' <returns>Returns value as IConnector object.</returns>
    ''' <remarks>Result may be Nothing if the name does not match the name of the supported connectors.</remarks>
    Public Shared Function GetConnectorByName(ByVal strConnectorName As String) As IConnector
        Dim oList As List(Of IConnector) = CType(GetConnectors(), Global.System.Collections.Generic.List(Of Global.Kofax.FaxRel.Connector.IConnector))
        Dim oConnector As IConnector = Nothing
        Dim en As List(Of IConnector).Enumerator = oList.GetEnumerator()
        ' Iterates the collection until the object is found.
        While (en.MoveNext())
            Dim oConn As IConnector = en.Current
            ' Compares the current connector internal name with the specified connector name.
            If String.Equals(strConnectorName, oConn.InternalName) Then
                oConnector = oConn
                Exit While
            End If
        End While
        Return oConnector
    End Function
End Class
