'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: KfxFaxUtil.vb
'
' Purpose: Defines the common constants used in this project.
'
' ****************************************************************************
''' <summary>
''' Defines the common constants used in this project.
''' </summary>
''' <remarks></remarks>
Public Class Constants

	''' <summary>
    ''' This enumeration lists the index of each tab page on the setup form.
    ''' </summary>
    ''' <remarks></remarks>
    Enum TabPageIndexEnum
        ''' <summary>
        ''' Use this to indicate the fax server tab page
        ''' </summary>
        ''' <remarks></remarks>
        FaxServerTab = 0
        ''' <summary>
        ''' Use this to indicate the fax settings tab page
        ''' </summary>
        ''' <remarks></remarks>
        FaxSettingsTab = 1
    End Enum
    ''' <summary>
    ''' Defines the Fax server name constant.
    ''' </summary>
    ''' <remarks></remarks>
    Public Const c_strKeyFaxServerName As String = "FAX_SERVER_NAME"
    ''' <summary>
    ''' Defines the connector name constant.
    ''' </summary>
    ''' <remarks></remarks>
    Public Const c_strKeyConnector As String = "CONNECTOR"
    ''' <summary>
    ''' Defines the path name constant.
    ''' </summary>
    ''' <remarks></remarks>
    Public Const c_strKeyPath As String = "PATH"
    ''' <summary>
    ''' Defines the connector's name constant.
    ''' </summary>
    ''' <remarks></remarks>
    Public Const c_strKeyConnectorName As String = "CONNECTOR_NAME"
	''' <summary>
	''' Defines the connector's username constant.
	''' </summary>
	''' <remarks></remarks>
	Public Const c_strKeyUsername As String = "USER_NAME"
	''' <summary>
	''' Defines the connector's password constant.
	''' </summary>
	''' <remarks></remarks>
	Public Const c_strKeyPassword As String = "PASSWORD"

    '*** Help
    ''' <summary>
    ''' Defines the help file name constant.
    ''' </summary>
    ''' <remarks></remarks>
    Public Const c_strHelpFileName As String = "KCEC-Fax.chm"
    ''' <summary>
    ''' Defines the help ID constant for the fax server tab.
    ''' </summary>
    ''' <remarks></remarks>
    Public Const c_strHelpIDFaxServerTab As String = "156256" '0x26260
    ''' <summary>
    ''' Defines the help ID constant for the settings tab.
    ''' </summary>
    ''' <remarks></remarks>
    Public Const c_strHelpIDSettingsTab As String = "156257" '0x26261
    ''' <summary>
    ''' Defines the help topic constant for the fax server tab.
    ''' </summary>
    ''' <remarks></remarks>
    Public Const c_strHelpTopicFaxServerTab As String = "Fax_Server_Tab.htm"
    ''' <summary>
    ''' Defines the help topic constant for the settings tab.
    ''' </summary>
    ''' <remarks></remarks>
    Public Const c_strHelpTopicSettingsTab As String = "Fax_Settings_Tab.htm"

    Public Const c_strHelpFileFaxSettingTab As String = "KCECFax_help\KECFax\KECFax_help\c_faxsettingstab.html"

    Public Const c_strHelpFileFaxServerTab As String = "KCECFax_help\KECFax\KECFax_help\c_faxxerverstab.html"

    Public Const c_strHelpFileDefault As String = "KCECFax_help\KECFax\KECFax_help\c_welcome.html"

    ''' <summary>
    ''' Cover Sheet modes for RightFax
    ''' </summary>
    ''' <remarks></remarks>
    Public Const COVER_NEVER As String = "0" ' Send the Fax without cover-sheet
    Public Const COVER_SERVER_DEP As String = "1" 'Cover-sheet enable/disable depends on Server/User-Profile (=default)
    Public Const COVER_ALWAYS As String = "2" ' Send the Fax with a cover-sheet

    ''' <summary>
    ''' Defines the delivery security mode for RightFax
    ''' </summary>
    ''' <remarks></remarks>
    Public Const DM_FAX As String = "0" ' Send the messages as Fax (without Secure Document or Certified Delivery option)
    Public Const DM_SECURE_DOC As String = "1" ' send the message as secure document (email with encrypted/signed PDF)
    Public Const DM_CERTIFIED_DELIVERY As String = "2" ' send the mesages as secure document with certified delivery

End Class
