'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: FacsimileException.vb
'
' Purpose: Defines the base exception class for fax connectors.
'
' ****************************************************************************
Imports Kofax.TAPCommon.TAPLib

''' <summary>
''' Defines the base exception class for fax connectors.
''' </summary>
''' <remarks></remarks>
Public Class FacsimileException
    Inherits TAPLibException
    ' Declares the error code property
    Private m_nErrorCode As Integer
    Protected Const cm_UnspecifiedErrorCode As Integer = -1
    ''' <summary>
    ''' Gets a number that identifies the current exception.
    ''' </summary>
    ''' <value></value>
    ''' <returns>The error number for the current exception.</returns>
    ''' <remarks></remarks>
    Public Property ErrorCode() As Integer
        Get
            Return m_nErrorCode
        End Get
        Set(ByVal value As Integer)
            m_nErrorCode = value
        End Set
    End Property
    ''' <summary>
    ''' Initializes a new instance of the FacsimileException class with a specified error message.
    ''' </summary>
    ''' <param name="strMessage">The message that describes the error.</param>
    ''' <remarks></remarks>
    Public Sub New(ByVal strMessage As String)
        MyBase.New(strMessage)
        ErrorCode = cm_UnspecifiedErrorCode
    End Sub
    ''' <summary>
    ''' Initializes a new instance of the FacsimileException class with a specified error code and error message.
    ''' </summary>
    ''' <param name="nErrorCode">The number that identifies the error.</param>
    ''' <param name="strMessage">The message that describes the error.</param>
    ''' <remarks></remarks>
    Public Sub New(ByVal nErrorCode As Integer, ByVal strMessage As String)
        MyBase.new(strMessage)
        ErrorCode = nErrorCode
    End Sub
End Class
