'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: UnusedFieldsException.vb
'
' Purpose: Defines the unused index fields exception class for fax connectors..
'
' ****************************************************************************
''' <summary>
''' Defines the unused index fields exception class for fax connectors.
''' </summary>
''' <remarks></remarks>
Public Class UnusedFieldsException
    Inherits FacsimileException
    Private m_arrDocFields() As String
    Private m_arrBatchFields() As String
    ''' <summary>
    ''' Gets the unused batch index fields as an array of String.
    ''' </summary>
    ''' <remarks></remarks>
    Public ReadOnly Property BatchFields() As String()
        Get
            Return m_arrBatchFields
        End Get
    End Property
    ''' <summary>
    ''' Gets the unused index fields as a single instance of String.
    ''' </summary>
    ''' <remarks></remarks>
    Public ReadOnly Property BatchFieldsAsString() As String
        Get
            Dim strResult As String = String.Empty
            If Not (BatchFields Is Nothing) Then
                strResult = String.Join(", ", BatchFields)
            End If
            Return strResult
        End Get
    End Property
    ''' <summary>
    ''' Gets the unused document index fields as an array of String.
    ''' </summary>
    ''' <remarks></remarks>
    Public ReadOnly Property DocumentFields() As String()
        Get
            Return m_arrDocFields
        End Get
    End Property

    ''' <summary>
    ''' Gets the unused index fields as a single instance of String.
    ''' </summary>
    ''' <remarks></remarks>
    Public ReadOnly Property DocumentFieldsAsString() As String
        Get
            Dim strResult As String = String.Empty
            If Not (DocumentFields Is Nothing) Then
                strResult = String.Join(", ", DocumentFields)
            End If
            Return strResult
        End Get
    End Property
    ''' <summary>
    ''' Initializes a new instance of the UnusedFieldsException class to 
    ''' the value indicated by an error message and an array of unused index fields.
    ''' </summary>
    ''' <param name="strMessage">The message that describes the error.</param>
    ''' <param name="arrDocFields">An array of name of the document index fields.</param>
    ''' <param name="arrBatchFields">An array of name of the batch index fields.</param>
    ''' <remarks></remarks>
    Public Sub New(ByVal strMessage As String, ByVal arrDocFields() As String, ByVal arrBatchFields() As String)
        MyBase.New(strMessage)
        m_arrDocFields = arrDocFields
        m_arrBatchFields = arrBatchFields
    End Sub
End Class
