'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: FaxConfigUtil.vb
'
' Purpose: Defines the facsimile configuration utility class for fax connectors.
'
' ****************************************************************************
Imports System.IO
Imports System.Reflection

''' <summary>
''' This utility retrieves specific configuration information from the embedded DLL.
''' </summary>
''' <remarks></remarks>
Public Class FaxConfigUtil
    ''' <summary>
    ''' Defines the Biscom solution config name.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property CONFIG_BISCOM() As String
        Get
            Return "biscom-SolutionConfig.xml"
        End Get
    End Property

    ''' <summary>
    ''' Defines the Kofax Communication Server solution config name.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property CONFIG_KCS() As String
        Get
            Return "kcs-SolutionConfig.xml"
        End Get
    End Property

    ''' <summary>
    ''' Defines the Captaris RightFax solution config name.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property CONFIG_CAPTARIS() As String
        Get
            Return "rightfax-SolutionConfig.xml"
        End Get
    End Property

    ''' <summary>
    ''' Defines the Test mode solution config name.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property CONFIG_TESTMODE() As String
        Get
            Return "testmode-SolutionConfig.xml"
        End Get
    End Property
    Public ReadOnly Property LIBRARY_DIR() As String
        Get
            Dim strDir As String = "Could not evaluate the library path."
            Dim myAssy As Assembly
            ' Gets the current assembly
            myAssy = [Assembly].GetExecutingAssembly
            ' Gets the current assembly location as working folder
            Try
                Dim fi As FileInfo = New FileInfo(myAssy.Location)
                strDir = fi.Directory.FullName
                fi = Nothing
            Catch ex As System.Security.SecurityException
            End Try
            Return strDir
        End Get
    End Property
    ''' <summary>
    ''' Gets the raw config as string which is embedded in the dll resource.
    ''' </summary>
    ''' <param name="strName"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Function GetConfig(ByVal strName As String) As String
        ' Declares the Assembly object
        Dim myAssy As [Assembly]
        ' Gets the current assembly
        myAssy = [Assembly].GetExecutingAssembly
        Dim rsStream As Stream = myAssy.GetManifestResourceStream("Kofax.FaxRel.Connector." + strName)
        Dim strConfig As String = String.Empty
        If Not rsStream Is Nothing Then
            Using rd As StreamReader = New StreamReader(rsStream)
                strConfig = rd.ReadToEnd()
                rd.Close()
            End Using
            rsStream.Close()
        End If
        Return strConfig
    End Function
End Class
