'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: FaxServerSetup.vb
'
' Purpose: Handles settings for the fax server setup tab page
'
' ****************************************************************************

Imports System.Windows.Forms
Imports Kofax.TAPCommon.TAPLib
Imports Kofax.FaxRel.Connector.My.Resources
Imports Kofax.TAPCommon.TAPEncryption

''' <summary>
''' Handles settings for the fax server setup tab page.
''' </summary>
''' <remarks></remarks>
Public Class FaxServerSetup

#Region "Members"

	Private m_frmSetup				As SetupForm
    Private m_oSetupDataNet			As IReleaseSetupDataNet
    Private m_strFaxServerName		As String
    Private m_strUsername			As String
    Private m_strPassword			As String = String.Empty
    Private m_strPath				As String
    Private m_oConnector			As IConnector
    Private m_strInternalConnectorName		As String
 
#End Region

#Region "Public subs/functions"

    ''' <summary>
    ''' Creates a new instance of the FaxServerSetup class.
    ''' </summary>
    ''' <param name="setupForm">The setup form class object.</param>
    ''' <param name="setupDataNet">The TAPLib SetupDataAdapterNet object.</param>
    ''' <remarks></remarks>
    Public Sub New(ByVal setupForm As SetupForm, ByVal setupDataNet As IReleaseSetupDataNet)
        m_frmSetup = setupForm
        m_oSetupDataNet = setupDataNet
    End Sub
    
    ''' <summary>
    ''' Returns the current fax server name.
    ''' </summary>
    ''' <value></value>
    ''' <returns>String value representing the current fax server name.</returns>
    ''' <remarks></remarks>
    Public ReadOnly Property FaxServerName() As String
        Get
            Return m_strFaxServerName
        End Get
    End Property

    ''' <summary>
    ''' Returns the current fax server connector.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
	Public Property Connector() As IConnector
		Get
			Return m_oConnector
		End Get
		Set(ByVal oConnector As IConnector)
			m_oConnector = oConnector
		End Set
	End Property

	''' <summary>
	''' Gets or set the Username property
	''' </summary>
	''' <value></value>
	''' <returns></returns>
	''' <remarks></remarks>
	Public Property Username() As String
		Get
			Return m_strUsername
		End Get
		Set(ByVal strUsername As String)
			m_strUsername = strUsername
		End Set
	End Property
	
	''' <summary>
	''' Gets or sets the Password property
	''' </summary>
	''' <value></value>
	''' <returns>String value represents current password.</returns>
	''' <remarks></remarks>
	Public Property Password() As String
		Get
			Return m_strPassword
		End Get
		Set(ByVal strPassword As String)
			m_strPassword = strPassword
		End Set
	End Property
	''' <summary>
	''' Gets or sets the Path property
	''' </summary>
	''' <value></value>
	''' <returns></returns>
	''' <remarks></remarks>
	Public Property Path() As String
		Get
			Return m_strPath
		End Get
		Set(ByVal strPath As String)
			m_strPath = strPath
		End Set
	End Property

	''' <summary>
	''' Gets or set the InternalConnectorName property
	''' </summary>
	''' <value></value>
	''' <returns></returns>
	''' <remarks></remarks>
	Public Property InternalConnectorName() As String
		Get
			Return m_strInternalConnectorName
		End Get
		Set(ByVal strConnectorName As String)
			m_strInternalConnectorName = strConnectorName

		End Set
 End Property

    ''' <summary>
    ''' Saves the current form data of the fax server tab page into the KC database.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub SaveSetupData()
        Dim oAscentDataCrypto As New AscentDataCrypto(m_oSetupDataNet)
        m_oSetupDataNet.UserName = oAscentDataCrypto.Encrypt(Username)
		' Encrypts the password if it is not empty
		If Not (String.IsNullOrEmpty(Password)) Then
            m_oSetupDataNet.Password = oAscentDataCrypto.Encrypt(Password)
		End If
        oAscentDataCrypto.SaveObjectID()
        CustomPropsUtil.WriteCustomProperty(m_oSetupDataNet.ICustomPropertiesNet, Constants.c_strKeyPath, Path)
        CustomPropsUtil.WriteCustomProperty(m_oSetupDataNet.ICustomPropertiesNet, Constants.c_strKeyConnector, m_strInternalConnectorName)
    End Sub

    ''' <summary>
    ''' Loads form data from the KC database for the fax server tab page.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub LoadSetupData()
        Dim oAscentDataCrypto As New AscentDataCrypto(m_oSetupDataNet)
        m_strFaxServerName = CustomPropsUtil.ReadCustomProperty(m_oSetupDataNet.ICustomPropertiesNet, Constants.c_strKeyFaxServerName)

        Username = CustomPropsUtil.ReadCustomProperty(m_oSetupDataNet.ICustomPropertiesNet, Constants.c_strKeyUsername)
        Password = CustomPropsUtil.ReadCustomProperty(m_oSetupDataNet.ICustomPropertiesNet, Constants.c_strKeyPassword)
        ' Tries to get username from SetupData if we can not retrieve username from the custom property
        If (String.IsNullOrEmpty(Username)) Then
            Username = m_oSetupDataNet.UserName
        End If
        ' Tries to get password from SetupData if we can not retrieve password from the custom property
        If (String.IsNullOrEmpty(Password)) Then
            Password = m_oSetupDataNet.Password
        End If
        ' Decrypts the username and password
        If (String.IsNullOrEmpty(Username)) Then
            Username = String.Empty
		Else
            Username = oAscentDataCrypto.Decrypt(Username)
		End If

		If (String.IsNullOrEmpty(Password)) Then
            Password = String.Empty
		Else
            Password = oAscentDataCrypto.Decrypt(Password)
		End If

        m_strPath = CustomPropsUtil.ReadCustomProperty(m_oSetupDataNet.ICustomPropertiesNet, Constants.c_strKeyPath)
        m_strInternalConnectorName = CustomPropsUtil.ReadCustomProperty(m_oSetupDataNet.ICustomPropertiesNet, Constants.c_strKeyConnector)

    End Sub

	''' <summary>
    ''' Verifies the current data on the fax server tab page.
	''' </summary>
	''' <remarks></remarks>
	Public Sub Verify()
		If (String.IsNullOrEmpty(m_frmSetup.txtPath.Text)) Then
			Dim strMsg As String
			With m_frmSetup
				strMsg = .lblPath.Text
				RemoveMnemonicAndUnderscore(strMsg)
				strMsg = String.Format(Resources.ERROR_INVALID_PATH, strMsg)
				Throw New InvalidPathException(strMsg)
			End With 
		Else If (String.IsNullOrEmpty(m_frmSetup.txtUsername.Text)) Then
			Dim strMsg As String
			strMsg = String.Format(Resources.ERROR_EMPTY_FIELD, m_frmSetup.lblUsername.Text)
			RemoveMnemonicAndUnderscore(strMsg)
			Throw New InvalidUsernameException(strMsg)
		Else
		End If
	End Sub

#End Region

#Region "Private subs/functions"
	''' <summary>
    ''' Replaces &amp; and ":" from the input text in order to use in the message.
	''' </summary>
	''' <param name="strStringToRemove"></param>
	''' <remarks></remarks>
	Private Sub RemoveMnemonicAndUnderscore(ByRef strStringToRemove As String)
		If Not (String.IsNullOrEmpty(strStringToRemove)) Then
			strStringToRemove = strStringToRemove.Replace("&", String.Empty)
			strStringToRemove = strStringToRemove.Replace(":", String.Empty)
		End If
	End Sub
#End Region

#Region "Events"
	''' <summary>
    ''' Handles the FaxServer combobox SelectedIndexChanged event 
	''' </summary>
	''' <param name="sender"></param>
	''' <param name="e"></param>
	''' <remarks></remarks>
    <Obsolete("Do not use", True)> _	
Public Sub OnFaxServer_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs)
		Dim cbSender As ComboBox = CType(sender, ComboBox)
		m_oConnector = CType(cbSender.SelectedItem, IConnector)
	End Sub
#End Region

End Class
