'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: BaseFaxConnector.vb
'
' Purpose: Defines the abstract base class for fax connectors.
'
' ****************************************************************************
Public Interface IConnector
    ''' <summary>
    ''' Gets the internal implementation name of the connector.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    ReadOnly Property InternalName() As String

    ''' <summary>
    ''' Gets or sets the user name value used for the fax server.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Property Username() As String

    ''' <summary>
    ''' Gets or sets the password value used for the fax server.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Property Password() As String

    ''' <summary>
    ''' Gets or sets the path specific value for the fax server.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Property Path() As String

    ''' <summary>
    ''' Gets or sets the fax number to dial.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Property FaxNumberField() As String

    ''' <summary>
    ''' Gets or sets the FromFaxNumberField value.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Property FromFaxNumberField() As String

    ''' <summary>
    ''' Gets or sets the From field value.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Property FromField() As String

    ''' <summary>
    ''' Gets or sets the To field value.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Property ToField() As String

    ''' <summary>
    ''' Gets or sets the SubjectField field value.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Property SubjectField() As String

    ''' <summary>
    ''' Indicates whether the path field is required.
    ''' </summary>
    ''' <value></value>
    ''' <returns>Boolean.True if the connector requires a specific path.</returns>
    ''' <remarks></remarks>
    ReadOnly Property IsPathRequired() As Boolean

    ''' <summary>
    ''' Indicates whether the specified fax connector supports the To field or not.
    ''' </summary>
    ''' <value></value>
    ''' <returns>Boolean.True if the connector supports the To field.</returns>
    ''' <remarks></remarks>
    ReadOnly Property IsToFieldSupported() As Boolean

    ''' <summary>
    ''' Indicates whether the specified fax connector supports the From field or not.
    ''' </summary>
    ''' <value></value>
    ''' <returns>Boolean.True if the connector supports the From field.</returns>
    ''' <remarks></remarks>
    ReadOnly Property IsFromFieldSupported() As Boolean

    ''' <summary>
    ''' Indicates whether the specified fax connector supports the SubjectField or not.
    ''' </summary>
    ''' <value></value>
    ''' <returns>Boolean.True if the connector supports the SubjectField field.</returns>
    ''' <remarks>Not all fax servers support this field on the fax header.</remarks>
    ReadOnly Property IsSubjectFieldSupported() As Boolean

    ''' <summary>
    ''' Indicates whether the specified fax connector is started.
    ''' </summary>
    ''' <value></value>
    ''' <returns>Boolean</returns>
    ''' <remarks></remarks>
    ReadOnly Property IsFaxStarted() As Boolean

    ''' <summary>
    ''' Indicates whether the specified fax connector is initialized.
    ''' </summary>
    ''' <value></value>
    ''' <returns>Boolean</returns>
    ''' <remarks></remarks>
    ReadOnly Property IsFaxInitialized() As Boolean

    ''' <summary>
    ''' Connect the user to the fax server using current settings.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Function Connect() As Boolean

    ''' <summary>
    ''' Connect the user to the fax server using the specified fax server name, and user's credential.
    ''' </summary>
    ''' <param name="strFaxServerName"></param>
    ''' <param name="strUsername"></param>
    ''' <param name="strPassword"></param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Function Connect(ByVal strFaxServerName As String, ByVal strUsername As String, ByVal strPassword As String) As Boolean

    ''' <summary>
    ''' Overrides the ToString method of the object to return the implemented connector's fax server name.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Function ToString() As String

    ''' <summary>
    ''' Builds the raw string configuration for the specified fax connector.
    ''' </summary>
    ''' <param name="strPath"></param>
    ''' <param name="strUsername"></param>
    ''' <param name="strPassword"></param>
    ''' <returns></returns>
    ''' <remarks>May be removed since we don't store the configuration string in CustomString.</remarks>
    Function BuildConfiguration(ByVal strPath As String, ByVal strUsername As String, ByVal strPassword As String) As String

    ''' <summary>
    ''' Initializes the specified fax connector. This method MUST be called before any other fax calls.
    ''' </summary>
    ''' <remarks></remarks>
    Sub InitializeFax()

    ''' <summary>
    ''' Starts the specified fax connector using associated information. This method MUST be called after the method InitializeFax is called.
    ''' </summary>
    ''' <remarks></remarks>
    Sub StartFax()

    ''' <summary>
    ''' Sends the list of Tiff images to the specified Fax connector.
    ''' </summary>
    ''' <param name="oListImages">List of tiff image paths.</param>
    ''' <remarks></remarks>
    Sub SendFax(ByVal oListImages As IList)

    ''' <summary>
    ''' Shuts down the fax connector.
    ''' </summary>
    ''' <remarks></remarks>
    Sub ShutdownFax()

    ''' <summary>
    ''' Unloads any resources used by the fax connector.
    ''' </summary>
    ''' <remarks></remarks>
    Sub DeInitializeFax()
    ''' <summary>
    ''' Verifies that the appropriate client software is installed.
    ''' </summary>
    ''' <exception cref="RequireClientMissingException">If any required client is not installed.</exception>
    ''' <remarks></remarks>
    Sub VerifyClientInstalled()
End Interface
