'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: IndexFieldsSetup.vb
'
' Purpose: Handles settings for the fax settings setup tab page
'
' ****************************************************************************

Imports Kofax.TAPCommon.TAPControls
Imports Kofax.TAPCommon.TAPLib
Imports Kofax.ReleaseLib
Imports Kofax.FaxRel.Connector.My.Resources

''' <summary>
''' Handles settings for the fax settings setup tab page.
''' </summary>
''' <remarks></remarks>
<Obsolete("Do not use", True)> _
Public Class IndexFieldsSetup

#Region "Members"
    
	Private m_oCtlLnkIndexFields	As TAPLinks
	Private m_frmSetup				As SetupForm
    Private m_oSetupDataNet			As IReleaseSetupDataNet

#End Region

#Region "Public subs/funtions"

    ''' <summary>
    ''' Creates a new instance of the IndexFieldsSetup class.
    ''' </summary>
    ''' <param name="setupForm">The setup form class object.</param>
    ''' <param name="setupDataNet">The TAPLib SetupDataAdapterNet object.</param>
    ''' <remarks></remarks>
    Public Sub New(ByVal setupForm As SetupForm, ByVal setupDataNet As IReleaseSetupDataNet)
        m_frmSetup = setupForm
        m_oSetupDataNet = setupDataNet
    End Sub

    ''' <summary>
    ''' Sets the value for labels, textboxes, comboboxes on the fax settings tab page.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub InitFormData()
        With m_frmSetup
			.ctlLnkIndexFields.SourceHeadingText = Resources.LBL_TAP_LNK_SRC
			.ctlLnkIndexFields.DestinationHeadingText = Resources.LBL_TAP_LNK_DST
        End With
        ConstructTAPLinkRows(True)
    End Sub

    ''' <summary>
    ''' Loads setup data from the KC database for the fax settings tab page.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub LoadTAPLinsRow()
        Dim ACLink As Link
        For Each ACLink In m_oSetupDataNet.ILinksNet
            For Each _row As TAPLinksRow In m_oCtlLnkIndexFields.Rows
                If (_row.Destination.ID.Equals(ACLink.Destination)) Then
                    _row.Source.SourceType = ACLink.SourceType
                    _row.SourceText = ACLink.Source
                    Exit For
                End If
            Next
        Next
    End Sub

    ''' <summary>
    ''' Renders the TAPLinkRows control based on the fax server type.
    ''' </summary>
    ''' <remarks>change this to add fields for the Export dialog</remarks>
    Public Sub ConstructTAPLinkRows(Optional ByVal bLoadFromKCDatabse As Boolean = False)
        Dim oConnector As IConnector = m_frmSetup.ClsSetup.ClsFaxServerSetup.Connector
        If (oConnector Is Nothing) Then Return

        m_oCtlLnkIndexFields = m_frmSetup.ctlLnkIndexFields
        m_oCtlLnkIndexFields.Init(m_oSetupDataNet)
        m_oCtlLnkIndexFields.RemoveAllRows()

        Dim oDestination As IDestination = New Destination()

        With oDestination
			.DisplayName = Resources.LBL_TAP_FAX_NUMBER_FIELD
			.ID = FaxDestination.c_IdFaxNumberField
            .Required = True
        End With

        m_oCtlLnkIndexFields.AddRow(oDestination, String.Empty)

        oDestination = New Destination()

        With oDestination
			.DisplayName = Resources.LBL_TAP_FAX_FROM_FIELD
			.ID = FaxDestination.c_IdFaxFromField
            .Required = False
        End With

        m_oCtlLnkIndexFields.AddRow(oDestination, String.Empty)

        If (oConnector.IsToFieldSupported) Then
            oDestination = New FaxDestination()
            With oDestination
				.DisplayName = Resources.LBL_TAP_FAX_TO_FIELD
				.ID = FaxDestination.c_IdToField
                .Required = False
            End With
            m_oCtlLnkIndexFields.AddRow(oDestination, String.Empty)
        End If

        oDestination = New FaxDestination()
        With oDestination
			.DisplayName = Resources.LBL_TAP_FAX_SENDER
			.ID = FaxDestination.c_IdSenderField
            .Required = False
        End With
        m_oCtlLnkIndexFields.AddRow(oDestination, String.Empty)

        If (oConnector.IsSubjectFieldSupported) Then
            oDestination = New FaxDestination()
            With oDestination
				.DisplayName = Resources.LBL_TAP_FAX_SUBJECT_FIELD
				.ID = FaxDestination.c_IdSubjectField
                .Required = False
            End With
            m_oCtlLnkIndexFields.AddRow(oDestination, String.Empty)
        End If
        If (bLoadFromKCDatabse) Then
            LoadTAPLinsRow()
        End If
    End Sub

    ''' <summary>
    ''' Saves the current form data of the fax settings tab page into the KC database.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub SaveSetupData()
        m_oSetupDataNet.ILinksNet.RemoveAll()  'TODO: Remove all or warm the user ?
        For Each row As TAPLinksRow In m_oCtlLnkIndexFields.Rows
            m_oSetupDataNet.ILinksNet.Add(row.Source.Text, row.Source.SourceType, row.Destination.ID)
        Next
    End Sub
#End Region

#Region "Event handlers"
 
    ''' <summary>
    ''' Verifies the current data on the fax settings tab page.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub Verify()
        m_oCtlLnkIndexFields.Verify()
    End Sub

    ''' <summary>
    ''' Handles the FaxServer combobox SelectedIndexChanged event
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
	Public Sub OnFaxServer_SelectedIndexChanged(ByVal sender As Object, ByVal e As EventArgs)
        ConstructTAPLinkRows()
    End Sub

#End Region
End Class
