'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: KofaxCommunicationServerConnector.vb
'
' Purpose: Defines the specific implementation for the KCS fax connector.
'
' ****************************************************************************
Imports Kofax.FaxRel.Connector.My.Resources
''' <summary>
''' Defines the specific implementation for the KCS fax connector.
''' </summary>
''' <remarks></remarks>
Public Class KofaxCommunicationServerConnector
    Inherits BaseFaxConnector

    Public Sub New()
        MyBase.New()
    End Sub
    ''' <summary>
    ''' Returns the internal implementation name of the connector.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property InternalName() As String
        Get
            Return "KOFAX_COMMUNICATION_SERVER_FAX"
        End Get
    End Property
    ''' <summary>
    ''' Overrides the Object.ToString method to return the connector name.
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function ToString() As String
        Return Resources.CONNECTOR_KCS
    End Function
    ''' <summary>
    ''' Indicates whether the 'Path' field is required.
    ''' </summary>
    ''' <value></value>
    ''' <returns>Boolean.True since the path value is required for the KCS fax connector.</returns>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property IsPathRequired() As Boolean
        Get
            Return True
        End Get
    End Property
    ''' <summary>
    ''' Indicates whether the 'To' field is supported on the target fax header.
    ''' </summary>
    ''' <value></value>
    ''' <returns>Boolean.False since the the 'To' field is not supported by the KCS fax connector.</returns>
    ''' <remarks></remarks>
    Overrides ReadOnly Property IsToFieldSupported() As Boolean
        Get
            Return False
        End Get
    End Property
    ''' <summary>
    ''' Indicates whether the 'SubjectField' field is supported on the target fax header.
    ''' </summary>
    ''' <value></value>
    ''' <returns>Boolean.True since the 'SubjectField' field is supported by the KCS fax connector.</returns>
    ''' <remarks></remarks>
    Public Overrides ReadOnly Property IsSubjectFieldSupported() As Boolean
        Get
            Return True
        End Get
    End Property
    ''' <summary>
    ''' Builds the raw configuration specific for the KCS fax connector.
    ''' </summary>
    ''' <param name="strPath">Specific path value. Optional.</param>
    ''' <param name="strUsername">The username to include in the configuration. Required.</param>
    ''' <param name="strPassword">The password to include in the configuration. Required.</param>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Overrides Function BuildConfiguration(ByVal strPath As String, ByVal strUsername As String, ByVal strPassword As String) As String
        Dim strConfigName As String = m_oKfxUtil.CONFIG_KCS
        Dim strRawConfig As String = m_oKfxUtil.GetConfig(strConfigName)
        If Not String.IsNullOrEmpty(strRawConfig) Then
            ' Replaces the pre-defined string "<Path>0.0.0.0</Path>" with the name or IP address of the KCS fax server.
            strRawConfig = strRawConfig.Replace("<Path>0.0.0.0</Path>", String.Format("<Path>{0}</Path>", strPath))
        End If
        Return strRawConfig
    End Function
End Class
