'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: MacroBuilder.vb
'
' Purpose: Handles Kofax Capture macroes setting.
'
' ****************************************************************************
Imports Kofax.ReleaseLib

Public Class MacroBuilder
    ''' <summary>
    ''' Builds macro name according to its link source type
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks>
    ''' </remarks>
    Public Shared Function BuildMacroName(ByVal strName As String, ByVal eIndexFieldType As KfxLinkSourceType) As String
        Dim strMacroName As String = String.Empty
        Select Case eIndexFieldType
            Case KfxLinkSourceType.KFX_REL_BATCHFIELD
                strMacroName = "{$" + strName + "}"
            Case KfxLinkSourceType.KFX_REL_INDEXFIELD
                strMacroName = "{@" + strName + "}"
            Case KfxLinkSourceType.KFX_REL_VARIABLE
                strMacroName = "{" + strName + "}"
            Case Else
                strMacroName = strName
        End Select
        Return strMacroName
    End Function
End Class
