'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: Setup.vb
'
' Purpose: Defines the setup class for setting up the release script.
'
' ****************************************************************************

Imports System.Windows.Forms
Imports Kofax.TAPCommon.TAPLib
Imports Kofax.ReleaseLib

''' <summary>
''' Defines the setup class for setting up the release script.
''' </summary>
''' <remarks></remarks>
Public Class Setup

#Region "Members"
    Private m_oFaxServerSetup			As FaxServerSetup
    'Private m_oIndexFieldsSetup			As IndexFieldsSetup
    Private m_frmSetup					As SetupForm
    Private m_oSetupDataNet				As IReleaseSetupDataNet
    Private m_strBatchClassName			As String
    Private m_strDocumentClassName		As String
	Private m_strExportConnectorName	As String
    Private m_bDirty					As Boolean = False
#End Region

#Region "Public sub/funtions"
    ''' <summary>
    ''' Determines whether user has changed the settings or not.
    ''' </summary>
    ''' <value>Boolean</value>
    ''' <returns>
    ''' True if user has made changes to the settings, otherwise False.
    ''' </returns> 
    ''' <remarks></remarks>
    Public Property IsDirty() As Boolean
        Get
            Return m_bDirty
        End Get
        Set(ByVal value As Boolean)
            m_bDirty = value
        End Set
    End Property


    ''' <summary>
    ''' Returns the current instance of the FaxServerSetup class object.
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public ReadOnly Property ClsFaxServerSetup() As FaxServerSetup
        Get
            Return m_oFaxServerSetup
        End Get
    End Property

	Public ReadOnly Property BatchClassName() As String
		Get
			Return m_strBatchClassName
		End Get
	End Property

	Public ReadOnly Property DocumentClassName() As String
		Get
			Return m_strDocumentClassName
		End Get
	End Property

	Public ReadOnly Property ExportConnectorName() As String
		Get
			Return m_strExportConnectorName
		End Get
	End Property

	Public ReadOnly Property SetupDataNet() As IReleaseSetupDataNet
		Get
			Return m_oSetupDataNet
		End Get
	End Property

	''' <summary>
    ''' Loads the general setup date from the KC database.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub LoadSetupData()
        m_oFaxServerSetup.LoadSetupData()
    End Sub

    ''' <summary>
    ''' Verifies the current setup data on the setup form.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub Verify()
        m_oFaxServerSetup.Verify()
    End Sub

    ''' <summary>
    ''' Saves the current setup data on the setup form.
    ''' </summary>
    ''' <remarks></remarks>
    Public Sub SaveSetupData()
        If Not m_bDirty Then Return
        m_oFaxServerSetup.SaveSetupData()
        m_bDirty = False
        SetupDataNet.Apply()
    End Sub

    ''' <summary>
    ''' Shows the setup form to the user.
    ''' </summary>
    ''' <param name="setupDataNet">The TAPLib SetupDataAdapterNet object.</param>
    ''' <param name="oActionEventHandler">The ActionEventHandler object.</param>
    ''' <returns>KfxReturnValue</returns>
    ''' <remarks></remarks>
    Public Function ShowForm(ByVal setupDataNet As IReleaseSetupDataNet, Optional oActionEventHandler as ActionEventHandler = Nothing) _
        As KfxReturnValue
        Dim eReturnValue As KfxReturnValue = KfxReturnValue.KFX_REL_SUCCESS
        m_oSetupDataNet = setupDataNet
        m_frmSetup = New SetupForm(Me)
        Try
            Dim eDialogResult As DialogResult
            Using m_frmSetup
                ConstructSetupClasses()
                LoadSetupData()
                InitFormData()
                eDialogResult = m_frmSetup.ShowDialog(oActionEventHandler)
            End Using
        Catch ex As Exception
			eReturnValue = KfxReturnValue.KFX_REL_ERROR
			Dim frmUnexpectedException As New UnexpectedExceptionForm(ex)
			frmUnexpectedException.ShowDialog()            
        End Try
        Return eReturnValue
    End Function
#End Region

#Region "Private sub/funtions"
    ''' <summary>
    ''' Sets the value for labels, textboxes, comboboxes on the setup form.
    ''' </summary>
    ''' <remarks></remarks>
	Private Sub InitFormData()
		m_strBatchClassName = SetupDataNet.BatchClassName
		m_strDocumentClassName = SetupDataNet.DocClassName
		m_strExportConnectorName = SetupDataNet.Name
	End Sub

    ''' <summary>
    ''' Creates intances of the FaxServerSetup and IndesFieldsSetup class.
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub ConstructSetupClasses()
        m_oFaxServerSetup = New FaxServerSetup(m_frmSetup, SetupDataNet)
    End Sub
#End Region
End Class


