'****************************************************************************
'  (c) Copyright 2009 Kofax, Inc.. All rights reserved.
'  Unauthorized use, duplication or distribution is strictly prohibited.
'****************************************************************************
'
' File: UnexpectedExceptionForm.vb
'
' Purpose: Displays details of an unexpected exception
'
' ****************************************************************************

Imports System.Drawing
Imports Kofax.FaxRel.Connector.My.Resources

''' <summary>
''' Displays details of an unexpected exception.
''' </summary>
''' <remarks></remarks>
Public Class UnexpectedExceptionForm

#Region "Members"

	Private m_oException As Exception

#End Region

	''' <summary>
    ''' Creates a new instance of UnexpectedExceptionForm.
	''' </summary>
	''' <param name="e">The exception to display its detail</param>
	''' <remarks></remarks>
    Public Sub New(ByVal e As Exception)
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        m_oException = e
    End Sub

	Public Shared Sub HandleUnexpectedException(ByVal ex as Exception)
		UnexpectedExceptionForm.HandleUnexpectedException(ex)
	End Sub

	''' <summary>
    ''' Handles the cmdOK button Click event.
	''' </summary>
	''' <param name="sender"></param>
	''' <param name="e"></param>
	''' <remarks></remarks>
	Private Sub cmdOK_Click(ByVal sender As Object, ByVal e As EventArgs) Handles cmdOK.Click
        Me.Close()
    End Sub

    ''' <summary>
    ''' Handles the frmUnexpectedException form Shown event.
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
	Private Sub frmUnexpectedException_Shown(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Shown
		Me.Text = Resources.COMMON_FULL_TITLE
		picErrorIcon.Image = SystemIcons.Error.ToBitmap()
        If Not m_oException Is Nothing Then
            Dim strMessage As String
			strMessage = String.Format(Resources.ERROR_UNEXPECTED_ERROR, m_oException.Message)
            lblException.Text = strMessage
            txtStackTrace.Text = m_oException.StackTrace
        End If
    End Sub

	''' <summary>
    ''' Handles the cmdDetail button Click event.
	''' </summary>
	''' <param name="sender"></param>
	''' <param name="e"></param>
	''' <remarks></remarks>
	Private Sub cmdDetail_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdDetail.Click
		If (txtStackTrace.Visible) Then
			txtStackTrace.Visible = False
			cmdDetail.Text = lblDetail.Text
		Else
			txtStackTrace.Visible = True
			cmdDetail.Text = lblNoDetail.Text
		End If
	End Sub
End Class