Imports System.Windows.Forms
Imports System.ComponentModel
Imports Kofax.FaxRel.Connector
Imports System.Threading

Public Class WaitingForm
    Private m_bConnected As Boolean
    Private m_bForceStop As Boolean
    Private m_connector As IConnector
    Private m_oException As Exception
    ''' <summary>
    ''' Determines whether the connection is succesful or not.
    ''' </summary>
    ''' <remarks></remarks>
    Public ReadOnly Property IsConnected() As Boolean
        Get
            Return m_bConnected
        End Get
    End Property
    ''' <summary>
    ''' Determines whether the user clicked on Stop button or not.
    ''' </summary>
    ''' <remarks></remarks>
    Public ReadOnly Property IsForceStop() As Boolean
        Get
            Return m_bForceStop
        End Get
    End Property
    ''' <summary>
    ''' Gets or sets the Connector to this instance.
    ''' </summary>
    ''' <remarks></remarks>
    Public ReadOnly Property Connector() As IConnector
        Get
            Return m_connector
        End Get
    End Property
    ''' <summary>
    ''' Gets the last exception occurred by this instance.
    ''' </summary>
    ''' <remarks></remarks>
    Public ReadOnly Property Exception() As Exception
        Get
            Return m_oException
        End Get
    End Property

    Public Sub New(ByVal oConnector As IConnector)
        Me.New()
        m_connector = oConnector
    End Sub

    Private Sub New()
        ' This call is required by the Windows Form Designer.
        InitializeComponent()
        ' Adds any initialization after the InitializeComponent() call.
        ctrlBackgroundWorker.WorkerReportsProgress = True
        ctrlBackgroundWorker.WorkerSupportsCancellation = True
        m_bConnected = False
    End Sub

    Private Sub cmdStop_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdStop.Click
        StopBackgroundThread()
        Me.Close()
    End Sub
    Private Sub StopBackgroundThread()
        ctrlGradientWaittingBar.Enabled = False
        m_bForceStop = True
        ' Disable the Stop button.
        Me.cmdStop.Enabled = False
        Try
            ' Cancel the asynchronous operation.
            ctrlBackgroundWorker.CancelAsync()
        Catch ex As Exception
            ' Ignored
        End Try
    End Sub

    Private Sub ctrlBackgroundWorker_DoWork(ByVal sender As System.Object, ByVal e As System.ComponentModel.DoWorkEventArgs) Handles ctrlBackgroundWorker.DoWork
        ' Gets the BackgroundWorker object that raised this event.
        Dim worker As BackgroundWorker = _
            CType(sender, BackgroundWorker)
        ' Assigns the result of the test to the Result property of the DoWorkEventArgs
        ' object. This is will be available to the  RunWorkerCompleted eventhandler.
        e.Result = TestConnection(CType(e.Argument, IConnector), worker, e)
    End Sub
    Private Sub ctrlBackgroundWorker_ProgressChanged(ByVal sender As System.Object, ByVal e As System.ComponentModel.ProgressChangedEventArgs) Handles ctrlBackgroundWorker.ProgressChanged

    End Sub
    Private Sub ctrlBackgroundWorker_RunWorkerCompleted(ByVal sender As System.Object, ByVal e As System.ComponentModel.RunWorkerCompletedEventArgs) Handles ctrlBackgroundWorker.RunWorkerCompleted
        ctrlGradientWaittingBar.Enabled = False
        If (e.Cancelled) Then
            Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
        ElseIf Not (e.Error Is Nothing) Then
            m_oException = e.Error
            Me.DialogResult = System.Windows.Forms.DialogResult.Cancel
        Else
            Me.DialogResult = System.Windows.Forms.DialogResult.OK
        End If
        Me.Close()
    End Sub

    Private Function TestConnection(ByVal connector As IConnector, ByVal worker As BackgroundWorker, _
                                     ByVal e As DoWorkEventArgs) As Long
        Dim result As Long = 0
        ' Aborts the operation if the user has canceled.
        ' Note that a call to CancelAsync may have set CancellationPending to true just after the
        ' last invocation of this method exits, so this code will not have the opportunity to set the 
        ' DoWorkEventArgs.Cancel flag to true. This means that RunWorkerCompletedEventArgs.Cancelled will
        ' not be set to true in your RunWorkerCompleted event handler. This is a race condition.
        If worker.CancellationPending Then
            e.Cancel = True
        Else
            ' NOTE: We shouldn't use a try catch block here (unless you rethrow the exception)  
            ' The backgroundworker will be able to detect any exception on this code.  
            ' if any exception is produced, it will be available to you on   
            ' the RunWorkerCompletedEventArgs object, method backgroundWorker_RunWorkerCompleted
            connector.Connect()
            ' Reports progress as a percentage of the total task.
            ctrlBackgroundWorker.ReportProgress(100)
        End If
        Return result
    End Function
    Private Sub WaitingForm_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

    End Sub

    Private Sub WaitingForm_Shown(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Shown
        ctrlGradientWaittingBar.Enabled = True
        ctrlTimer.Enabled = True
    End Sub

    Private Sub ctrlTimer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ctrlTimer.Tick
        ' Starts the asynchronous operation.
        ctrlBackgroundWorker.RunWorkerAsync(Connector)
        Dim timer As Windows.Forms.Timer = CType(sender, Windows.Forms.Timer)
        timer.Enabled = False
    End Sub
End Class
