/****************************************************************************
*	(c) Copyright 2009 Kofax, Inc.. All rights reserved.
*	Unauthorized use, duplication or distribution is strictly prohibited.
*****************************************************************************
*
*	File:		FaxInterface.h
*
*	Purpose:	CFaxInterface provides COM level access to funtionalities of 
*				tna_fax library. 
*
****************************************************************************/
#pragma once
#include "resource.h"       // main symbols
#include <stdio.h>

#include <atlbase.h>   // for converting from BSTR to char* and back
#include <atlconv.h>   // for converting from BSTR to char* and back

#include "tna_fax_COM.h"
#include "ServerProperties.h"
// Includes the fax API header
#include <tna_fax.h>

#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif

// CFaxInterface

class ATL_NO_VTABLE CFaxInterface :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CFaxInterface, &CLSID_FaxInterface>,
	public ISupportErrorInfo,
	public IFaxInterface
{
public:
	CFaxInterface()
		: m_hModuleDLL(NULL)
		, m_pFax(NULL)
		, m_bInterfaceStarted(FALSE)
		, m_bInitialised(FALSE)
	{
		ATLTRACE("CFaxInterface() is enterred.");
	}

DECLARE_REGISTRY_RESOURCEID(IDR_FAXINTERFACE)

BEGIN_COM_MAP(CFaxInterface)
	COM_INTERFACE_ENTRY(IFaxInterface)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()
	// ISupportsErrorInfo
	STDMETHOD(InterfaceSupportsErrorInfo)(REFIID riid);

	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{	
		return S_OK;
	}

	void FinalRelease()
	{
	}

public:
	/**
	  * Defines the cover-sheet mode
	  */	
	enum CoverModes {
		COVER_NEVER,         //!< Send the Fax without cover-sheet
		COVER_SERVER_DEP,    //!< Cover-sheet enable/disable depends on Server/User-Profile (=default)
		COVER_ALWAYS         //!< Send the Fax with a cover-sheet
	}; 
	
	/**
	  * Defines the delivery security mode
	  */	
	enum DeliveryModes {
		DM_FAX=0,                //!< Send the messages as Fax (without Secure Document or Certified Delivery option)
		DM_SECURE_DOC=1,         //!< send the message as secure document (email with encrypted/signed PDF)
		DM_CERTIFIED_DELIVERY=3  //!< send the mesages as secure document with certified delivery
	}; 

	// COM Methods
	// ----------------------------
	
	// Purpose: Starts the C++ fax interface.
	// param: bstrAppPath [in] the directory where the program started
	// param: bstrRawConfig [in] the raw configuration in XML format.
	// param: bstrXSLTPath [in] the XSLT file path for transformation inside C++ interface.
	// Returns: S_OK if operation performed successful.
	STDMETHOD(Start)(BSTR bstrAppPath, BSTR bstrRawConfig, BSTR bstrXSLTPath);

	// Purpose: Shuts down the fax interface. Tells the fax interface to free any resources used.
	// param: nTimeout [in] the shut down time-out in miliseconds.
	// Returns: S_OK if operation performed successful.
	STDMETHOD(Shutdown)(LONG lTimeout);

	// Purpose: Gets the active server properties.
	// param: pResponse [in,out] the server properties.
	// param: bstrUser [in] the username used to retrieve the fax server properties.
	// param: bstrPassword [in] the user's password used to retrieve the fax server properties.
	// Returns: S_OK if operation performed successful, S_FALSE if operation failed.
	//			E_POINTER, E_NOINTERFACE if out of memory or no interface.
	STDMETHOD(GetFaxServerProperties)(BSTR bstrUser, BSTR bstrPassword, IServerProperties** pResponse);

	// Purpose: Sends the fax from an existing TIFF file.
	// param: bstrUser [in] the username that being used to send the fax.
	// param: bstrPassword [in] the user's password that being used to send the fax.
	// param: bstrTiffFilePath [in] the path to the TIF file that being sent to fax.
	// param: bstrNumberToDial [in] the fax number to dial.
	// param: bstrExpectedCSI [in] the expected called subscriber identification, or a part of it, for verification that the correct 
	//		  destination has been called. The sending proceeds only if the string specified here can be found somewhere within the received CSI.
	// param: bstrNameOfRecipient [in] the recipient's name that being inserted into fax header line.
	// param: bstrSourceTSI [in] the origin subscriber identification, the recipient should send a reply to this fax number.
	// param: bstrNameOfSender [in] the sender name that being inserted into fax header line if supported.
	// Returns: S_OK if operation performed successful.
	STDMETHOD(SendFaxFromFile)(BSTR bstrUser, BSTR bstrPassword, BSTR bstrTiffFilePath, BSTR bstrNumberToDial, BSTR bstrExpectedCSI, BSTR bstrNameOfRecipient, BSTR bstrSourceTSI, BSTR bstrNameOfSender, BSTR bstrSubject);

	// Purpose: Sends the fax from an existing TIFF file.
	// param: bstrUser [in] the username that being used to send the fax.
	// param: bstrPassword [in] the user's password that being used to send the fax.
	// param: bstrTiffFilePath [in] the path to the TIF file that being sent to fax.
	// param: bstrNumberToDial [in] the fax number to dial.
	// param: bstrExpectedCSI [in] the expected called subscriber identification, or a part of it, for verification that the correct 
	//		  destination has been called. The sending proceeds only if the string specified here can be found somewhere within the received CSI.
	// param: bstrNameOfRecipient [in] the recipient's name that being inserted into fax header line.
	// param: bstrSourceTSI [in] the origin subscriber identification, the recipient should send a reply to this fax number.
	// param: bstrNameOfSender [in] the sender name that being inserted into fax header line if supported.
	// Returns: S_OK if operation performed successful.
	STDMETHOD(SendFaxFromFileExt)(
		BSTR bstrUser, 
		BSTR bstrPassword, 
		BSTR bstrTiffFilePath, 
		BSTR bstrNumberToDial, 
		BSTR bstrExpectedCSI, 
		BSTR bstrNameOfRecipient, 
		BSTR bstrSourceTSI, 
		BSTR bstrNameOfSender, 
		BSTR bstrSubject, 
		BSTR bstrCoverMode,
		BSTR bstrOwner,
		BSTR bstrBilling1,
		BSTR bstrBilling2,
		BSTR bstrDeliveryMode,
		BSTR bstrSecureDeliveryPassword

		);

	// Purpose: Determines if the current version of the wrapper is compatible with
	//			the fax library version.
	// param: lExpectedVersion [in] the parameter must be set to the API version used during build of the application. 
	// param: lMinVersion [in] the You may optionaly specify the used API features using to lowest API which supports
	//		  all this features. If you do not know this version use 0.
	// param: pCurrentVersion [in, out] the LONG pointer that holds the current TNA_Fax version.
	// param: pCompatible [in, out] the Boolean pointer that holds the Boolean value which indicates whether this wrapper is compatible to TNA_Fax library.
	// Returns: S_OK if operation performed successful.
	STDMETHOD(IsCompatible)(LONG lExpectedVersion, LONG lMinVersion, LONG* pCurrentVersion, VARIANT_BOOL* pCompatible);
	
	// Purpose: Initializes the fax interface. Loads the tna_fax.dll into memory 
	//			and initialize the fax interface from DLL's handle.
	// Returns: S_OK if operation performed successful.
	STDMETHOD(InitializeFax)();
	
	// Purpose: De-Initializes the fax interface. Un-Loads the tna_fax.dll from 
	//			the memory.
	// param: pResponse [in,out] the server properties.
	// Returns: S_OK if operation performed successful.
	STDMETHOD(DeInitializeFax)();

protected:
	// Class helper Methods
	// ----------------------------

	// Purpose: Loads a string from resource.
	// param: uID [in] the resource ID.
	// Returns: The resource message.
	TCHAR* CFaxInterface::LoadStringResource(UINT uID);
protected:
	// Purpose: Reports the error to the caller.
	// param: nErrorCode [in] the error code number.
	// param: uIDErrorMessage [in] the resource ID of the error message.
	// Returns: Error code.
	HRESULT ReportError(long nErrorCode, UINT uIDErrorMessage);
	// Purpose: Reports the error to the caller.
	// param: nErrorCode [in] the error code number.
	// param: strErrorMessage [in] the message that describes the error.
	// Returns: Error code.
	HRESULT ReportError(long nErrorCode, LPCSTR strErrorMessage);
	// Purpose: Determines if the specified file name is exist or not.
	// param: szFileName[in] the file name to check.
	// Returns: TRUE if the file is exist and accessible, otherwise FALSE.
	BOOL IsFileExist(TCHAR* szFileName);
	// Purpose: Writes an event to Event Log database.
	// param: szEventMsg[in] the event message.
	// param: wEventType[in] the event type.
	// param: szSourceName[in] the souce name.
	// Returns: TRUE if the event was succesfully writen to the event log, otherwise FALSE.
	bool WriteEventLog(LPCSTR szEventMsg,WORD wEventType = NULL);
	// Purpose: Writes an event to Event Log database.
	// param: szEventMsg[in] the event message.
	// param: wEventType[in] the event type.
	// param: szSourceName[in] the souce name.
	// Returns: TRUE if the event was succesfully writen to the event log, otherwise FALSE.
	bool WriteEventLog(LPCTSTR szEventMsg,WORD wEventType = NULL);

private:
	HMODULE m_hModuleDLL;
	kofax::tna::FaxInterface* m_pFax;
	BOOL m_bInterfaceStarted;
	BOOL m_bInitialised;
};

OBJECT_ENTRY_AUTO(__uuidof(FaxInterface), CFaxInterface)
