/****************************************************************************
*	(c) Copyright 2009 Kofax, Inc.. All rights reserved.
*	Unauthorized use, duplication or distribution is strictly prohibited.
*****************************************************************************
*
*	File:		ServerProperties.cpp
*
*	Purpose:	CServerProperties wraps around the ServerProperties class
*				defined in tna_fax.h of the tna_fax library.
*
****************************************************************************/

#include "stdafx.h"
#include "ServerProperties.h"

// CServerProperties

// Purpose: Gets the active fax server type.
// Returns: The server type in String.
STDMETHODIMP CServerProperties::GetFaxServerType(BSTR* pServerType)
{
	m_bstServerType.CopyTo(pServerType);
	return S_OK;
}

// Purpose: Gets the active fax server version.
// Returns: The server version in String.
STDMETHODIMP CServerProperties::GetFaxServerVersion(BSTR* pServerVersion)
{
	m_bstServerVersion.CopyTo(pServerVersion);
	return S_OK;
}

// Purpose: Gets the fax server type from this instance.
// Returns: S_OK if successful, E_POINTER if the pVal is NULL.
STDMETHODIMP CServerProperties::get_FaxServerType(BSTR* pVal)
{
	if (NULL == pVal) return E_POINTER;
	m_bstServerType.CopyTo(pVal);
	return S_OK;
}
// Purpose: Sets the fax server type to this instance.
// Returns: S_OK
STDMETHODIMP CServerProperties::put_FaxServerType(BSTR newVal)
{
	m_bstServerType.Empty();
	m_bstServerType.Append(newVal);
	return S_OK;
}
// Purpose: Gets the fax server version from this instance.
// Returns: S_OK if successfull, E_POINTER if pVal is NULL.
STDMETHODIMP CServerProperties::get_FaxServerVersion(BSTR* pVal)
{
	if (NULL == pVal) return E_POINTER;
	m_bstServerVersion.CopyTo(pVal);
	return S_OK;
}
// Purpose: Sets the fax server version to this instance.
// Returns: S_OK
STDMETHODIMP CServerProperties::put_FaxServerVersion(BSTR newVal)
{
	m_bstServerVersion.Empty();
	m_bstServerVersion.Append(newVal);
	return S_OK;
}
