/****************************************************************************
*	(c) Copyright 2009 Kofax, Inc.. All rights reserved.
*	Unauthorized use, duplication or distribution is strictly prohibited.
*****************************************************************************
*
*	File:		ServerProperties.h
*
*	Purpose:	CServerProperties wraps around the ServerProperties class
*				defined in tna_fax.h of the tna_fax library.
*
****************************************************************************/
#pragma once
#include "resource.h"       // main symbols

#include "tna_fax_COM.h"


#if defined(_WIN32_WCE) && !defined(_CE_DCOM) && !defined(_CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA)
#error "Single-threaded COM objects are not properly supported on Windows CE platform, such as the Windows Mobile platforms that do not include full DCOM support. Define _CE_ALLOW_SINGLE_THREADED_OBJECTS_IN_MTA to force ATL to support creating single-thread COM object's and allow use of it's single-threaded COM object implementations. The threading model in your rgs file was set to 'Free' as that is the only threading model supported in non DCOM Windows CE platforms."
#endif



// CServerProperties

class ATL_NO_VTABLE CServerProperties :
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CServerProperties, &CLSID_ServerProperties>,
	public IServerProperties
{
public:
	CServerProperties()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_SERVERPROPERTIES)


BEGIN_COM_MAP(CServerProperties)
	COM_INTERFACE_ENTRY(IServerProperties)
END_COM_MAP()



	DECLARE_PROTECT_FINAL_CONSTRUCT()

	HRESULT FinalConstruct()
	{
		return S_OK;
	}

	void FinalRelease()
	{
	}

public:
	// COM Methods
	// ----------------------------
	
	// Purpose: Gets the active fax server type.
	// Returns: The server type in String.
	STDMETHOD(GetFaxServerType)(BSTR* pServerType);
	
	// Purpose: Gets the active fax server version.
	// Returns: The server version in String.
	STDMETHOD(GetFaxServerVersion)(BSTR* pServerVersion);
public:
	// Property set/put Methods
	// ----------------------------
	STDMETHOD(get_FaxServerType)(BSTR* pVal);
	STDMETHOD(put_FaxServerType)(BSTR newVal);
	STDMETHOD(get_FaxServerVersion)(BSTR* pVal);
	STDMETHOD(put_FaxServerVersion)(BSTR newVal);
	
private:
	CComBSTR m_bstServerType;
	CComBSTR m_bstServerVersion;
};

OBJECT_ENTRY_AUTO(__uuidof(ServerProperties), CServerProperties)

